#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include "qcap.h"
#include "qcap.windef.h"

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

private slots:

    void on_Slider_Alpha_valueChanged(int value);

    void on_Slider_Red_valueChanged(int value);

    void on_Slider_Green_valueChanged(int value);

    void on_Slider_Blue_valueChanged(int value);

    void on_Slider_Threshold_valueChanged(int value);

    void on_pushButton_clicked();

public:

        Ui::MainWindow *ui;

    /* CAPTURE INFO */

        PVOID               m_pDevice[ 2 ];

        ULONG               m_nVideoWidth[ 2 ];

        ULONG               m_nVideoHeight[ 2 ];

        double              m_dVideoFrameRate[ 2 ];

        ULONG               m_bVideoIsInterleaved[ 2 ];

        ULONG               m_nAudioChannels[ 2 ];

        ULONG               m_nAudioBitsPerSample[ 2 ];

        ULONG               m_nAudioSampleFrequency[ 2 ];

    /* OTHER INFO */

        QString             m_str_info;

        bool                m_bEnableColorKey;
};

#endif // MAINWINDOW_H
